/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import net.sourceforge.dvb.projectx.common.Resource;

/**
 * Messages
 *
 * @author Arno
 * @version $Id: GStrings.java,v 1.1 2006/12/23 13:26:53 java Exp $
 */
public class GStrings {
    private static final String BUNDLE_NAME = "gdialog"; //$NON-NLS-1$

    private static ResourceBundle aResourceBundle = null;

    private GStrings() {
    }

    protected static ResourceBundle getResourceBundle() {
        if (aResourceBundle == null) {
            String tmpName = BUNDLE_NAME;
            try {
                String tmpLang = Resource.getChosenLanguage();
                Locale tmpLocale = new Locale(tmpLang);
                aResourceBundle = ResourceBundle.getBundle(tmpName, tmpLocale);
            } catch (MissingResourceException e) {
                Locale tmpLocale = new Locale("en");
                aResourceBundle = ResourceBundle.getBundle(tmpName, tmpLocale);
            } catch (Exception exc) {
                GConsole.setErrorMessage(exc);
            }
        }
        return aResourceBundle;
    }
    
    public static String getString(String key) {
        try {
            return getResourceBundle().getString(key);
        } catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }
}
